/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.ComponentModel;
using System.ComponentModel.Design;

using Borland.Eco.Subscription;
using Borland.Eco.UmlRt;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.ObjectImplementation;
using Borland.Eco.Services;
using Borland.Eco.Services.Impl;
using Borland.Eco.Persistence;
using Borland.Eco.Framework;
using Borland.Eco.Framework.DefaultImpl;
using Borland.Eco.Internal.DefaultImpl;
using Borland.Eco.DesignTimeAttributes;
using Borland.Eco.Globalization;
using Borland.Eco.Ocl.Support;

namespace Borland.Eco.Handles
{
	[ToolboxItem(false)]
	public abstract class EcoSpace: System.ComponentModel.Component, IEcoServiceProvider, IDisposable
	{
		private readonly DateTime m_CreateTime = DateTime.Now;

		public abstract System.Object GetEcoService(System.Type serviceType);
#if CF
		protected virtual System.Object GetService(System.Type service)
#else
		protected override System.Object GetService(System.Type service)
#endif
		{
			System.Object result = GetEcoService(service);
#if !CF
			if (result == null)
			{
				result = base.GetService(service);
			}
#endif
			return result;
		}
		[Browsable(false)]
		[DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
		public abstract bool Active
		{
			get;
			set;
		}
		public abstract IEcoTypeSystem TypeSystem
		{
			get;
		}
		public abstract void SubscribeToActive(ISubscriber subscriber);

#if CF
		public void Dispose()
		{
			Dispose(true);
			GC.SuppressFinalize(this);
		}
#endif

		protected override void Dispose(Boolean disposing)
		{
			if (disposing)  // should really be done by sub classes, but just in case.
				Active = false;
			base.Dispose(disposing);
		}

		[Browsable(false)]
		[DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
		public DateTime CreateTime
		{
			get { return m_CreateTime; }
		}

	}

	[Designer("Borland.Eco.Handles.Design.EcoSpaceDesigner, Borland.Eco.Handles.Design", typeof(IRootDesigner))]
	[ToolboxItem(false)]
	[ComponentHelpAttribute("Borland.Eco.Handles.Design.EcoSpaceInspector", "Borland.Eco.Handles.Design")]
	public class DefaultEcoSpace: EcoSpace // must not be abstract, for designers sake
	{
		private bool m_AllowDeactivateDirty;
		private IPersistenceMapper m_IPersistenceMapper;
		private readonly EcoSpacePartList m_MandatoryParts = new EcoSpacePartList();
		protected  EcoSpacePartList MandatoryParts{ get { return m_MandatoryParts; } }
		private readonly CacheImpl m_CacheImpl;
		protected CacheImpl DefaultCacheImpl{ get { return m_CacheImpl; } }
		private readonly UndoImpl m_UndoImpl;
		protected UndoImpl DefaultUndoImpl{ get { return m_UndoImpl; } }
		private readonly PersistenceHandlerImpl m_PersistenceHandlerImpl;
		protected PersistenceHandlerImpl DefaultPersistenceHandlerImpl{ get { return m_PersistenceHandlerImpl; } }
		private readonly FrontsidePolicy m_frontsidePolicy = new FrontsidePolicy();
		protected FrontsidePolicy FrontsidePolicy { get { return m_frontsidePolicy; } }
		private readonly LocatorFactory m_locatorFactory = new LocatorFactory();
		protected LocatorFactory LocatorFactory { get { return m_locatorFactory; } }
		private readonly EcoServiceProvider m_ecoServiceProvider = new EcoServiceProvider();
		protected EcoServiceProvider EcoServiceProvider { get { return m_ecoServiceProvider; } }
		private readonly ChangeHandler m_ChangeHandler = new ChangeHandler();
		protected ChangeHandler ChangeHandler { get { return m_ChangeHandler; } }
		private OclServicesImpl m_oclServicesImpl;
		protected OclServicesImpl OclServicesImpl { get { return m_oclServicesImpl; } }
		private readonly ExtentServiceImpl m_ExtentService;
		protected ExtentServiceImpl DefaultExtentService  { get { return m_ExtentService; } }
		private readonly PersistenceServiceImpl m_PersistenceService;
		protected PersistenceServiceImpl DefaultPersistenceService  { get { return m_PersistenceService; } }
		private readonly ExternalIdServiceImpl m_ExternalIdService = new ExternalIdServiceImpl();
		protected ExternalIdServiceImpl DefaultExternalIdService  { get { return m_ExternalIdService; } }
		private readonly StateServiceImpl m_StateService = new StateServiceImpl();
		protected StateServiceImpl DefaultStateService  { get { return m_StateService; } }
		private readonly VersionServiceImpl m_VersionService = new VersionServiceImpl();
		protected VersionServiceImpl DefaultVersionService  { get { return m_VersionService; } }
		private readonly DirtyListServiceImpl m_DirtyListService = new DirtyListServiceImpl();
		protected DirtyListServiceImpl DefaultDirtyListService  { get { return m_DirtyListService; } }
		private readonly VariableFactoryServiceImpl m_VariableFactoryService;
		protected VariableFactoryServiceImpl DefaultVariableFactoryService  { get { return m_VariableFactoryService; } }


		private static ITypeSystemService typeSystemProvider;

		public const string GetTypeSystemServiceName = "GetTypeSystemService";
		public static ITypeSystemService GetTypeSystemService()
		{
			if (typeSystemProvider == null)
				lock(typeof(DefaultEcoSpace))
				{
					if (typeSystemProvider == null)
						typeSystemProvider = MakeTypeService(typeof(DefaultEcoSpace));
				}
			return typeSystemProvider;
		}

		protected virtual ITypeSystemService GetTypeSystemProvider()
		{
			return DefaultEcoSpace.GetTypeSystemService();
		}

		static public ITypeSystemService MakeTypeService(System.Type ecoSpaceType)
		{
			return new TypeSystemServiceImpl(ecoSpaceType).TypeSystemService;
		}

		static protected ITypeSystemService MakeTypeService(object dummy, System.Type ecoSpaceType)
		{
			return MakeTypeService(ecoSpaceType);
		}

		public override System.Object GetEcoService(System.Type serviceType)
		{
			return m_ecoServiceProvider.GetEcoService(serviceType);
		}

		[Browsable(false)]
		[DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
		public bool Persistent
		{
			get { return PersistenceMapper != null; }
		}

		private bool m_Active;

		///<exception cref="InvalidOperationException">Thrown if trying to set Active to false when there are dirty objects in the cache.</exception>
		[Browsable(false)]
		[DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
		public override bool Active
		{
			get { return m_Active; }
			set
			{
				if (value == Active)
					return;
				if (value)
				{
					if (!TypeSystem.IsRunnable)
						throw new InvalidOperationException(TypeSystem.NonRunnableReason);
					m_CacheImpl.Persistent = Persistent;
					if (Persistent)
					{
						m_IPersistenceMapper = PersistenceMapper.GetPersistenceMapper(GetTypeSystemProvider());
						m_ChangeHandler.PersistenceMapper = m_IPersistenceMapper;
						m_PersistenceHandlerImpl.PersistenceMapper = m_IPersistenceMapper;
					}
					m_MandatoryParts.Activate();
				}
				else
				{
					IDirtyListService dirtyListService = GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
					if (!AllowDeactivateDirty && (dirtyListService != null) && dirtyListService.HasDirtyObjects())
						throw new InvalidOperationException(HandlesStringRes.sDeactivatingWithDirtyObjects);

					m_MandatoryParts.Deactivate();
					if (m_IPersistenceMapper != null)
					{
						m_PersistenceHandlerImpl.PersistenceMapper = null;
						m_ChangeHandler.PersistenceMapper = null;
						PersistenceMapper.ReturnPersistenceMapper(m_IPersistenceMapper);
						m_IPersistenceMapper = null;
					}
				}
				m_Active = value;
				m_ActiveChangedPublisher.Send(this, EventArgs.Empty);
			}
		}
		// FIXME LocalizableCategory and LocalizableDescription
		[DefaultValue(false)]
		public bool AllowDeactivateDirty
		{
			get { return m_AllowDeactivateDirty; }
			set { m_AllowDeactivateDirty = value;}
		}

		public virtual void Initialize()
		{
			m_oclServicesImpl = new OclServicesImpl(GetTypeSystemProvider().TypeSystem);
			// Install cutom operations
			foreach (EcoOclOperationAttribute oa in Attribute.GetCustomAttributes(this.GetType(), typeof(EcoOclOperationAttribute)))
			{
				IOclOperation operation = Activator.CreateInstance(oa.Operation) as IOclOperation;
				if (operation != null)
				{
					if (oa.IsQuery)
						m_oclServicesImpl.OclService.InstallOperation(operation);
					m_oclServicesImpl.ActionLanguageService.InstallOperation(operation);
				}
			}

			// Cache
			m_CacheImpl.LocatorFactory = m_locatorFactory.Factory;

			// Undo
			m_UndoImpl.PersistenceHandler = m_PersistenceHandlerImpl.PersistenceHandler;
			m_UndoImpl.Cache = m_CacheImpl.Cache;
			m_UndoImpl.ObjectRepresentationProvider = m_frontsidePolicy.ObjectRepresentationProvider;

			// PersistenceHandler
			m_PersistenceHandlerImpl.Cache = m_CacheImpl.Cache;
			m_PersistenceHandlerImpl.ObjectRepresentationProvider = m_frontsidePolicy.ObjectRepresentationProvider;
			m_PersistenceHandlerImpl.ChangeHandler = m_ChangeHandler;

			m_locatorFactory.LocatorOwner = m_frontsidePolicy.LocatorOwner;

			m_frontsidePolicy.UndoService = m_UndoImpl.UndoService;
			m_frontsidePolicy.Cache = m_UndoImpl.UndoableCache;
			m_frontsidePolicy.ServiceProvider = m_ecoServiceProvider;
			m_frontsidePolicy.PersistenceHandler = m_PersistenceHandlerImpl.PersistenceHandler;
			m_frontsidePolicy.TypeSystem = GetTypeSystemProvider().TypeSystem;
			m_frontsidePolicy.VariableFactory = m_VariableFactoryService;

			m_ChangeHandler.ObjectRepresentationProvider = m_frontsidePolicy.ObjectRepresentationProvider;
			m_ChangeHandler.Cache = m_CacheImpl.Cache;

			// ExtentService
			m_ExtentService.ObjectRepresentationProvider = m_frontsidePolicy.ObjectRepresentationProvider;
			m_ExtentService.ObjectFactory = m_frontsidePolicy.ObjectFactoryService;
			m_ExtentService.Cache = m_CacheImpl.Cache;
			m_ExtentService.DirtyListService = m_DirtyListService;
			m_ExtentService.PersistenceHandler = m_PersistenceHandlerImpl.PersistenceHandler;
			m_ExtentService.VersionService = m_VersionService;

			// ExternalIdService
			m_ExternalIdService.ObjectRepresentationProvider = m_frontsidePolicy.ObjectRepresentationProvider;
			m_ExternalIdService.Cache = m_CacheImpl.Cache;
			m_ExternalIdService.PersistenceHandler = m_PersistenceHandlerImpl.PersistenceHandler;


			// StateService
			m_StateService.ObjectRepresentationProvider = m_frontsidePolicy.ObjectRepresentationProvider;
			m_StateService.Cache = m_CacheImpl.Cache;

			// VersionService
			m_VersionService.ObjectRepresentationProvider = m_frontsidePolicy.ObjectRepresentationProvider;
			m_VersionService.Cache = m_CacheImpl.Cache;
			m_VersionService.PersistenceHandler = m_PersistenceHandlerImpl.PersistenceHandler;

			// DirtyListService
			m_DirtyListService.ObjectRepresentationProvider = m_frontsidePolicy.ObjectRepresentationProvider;
			m_DirtyListService.Cache = m_CacheImpl.Cache;
			m_DirtyListService.VariableFactoryService = m_VariableFactoryService;

			// VariableFactoryService
			m_VariableFactoryService.ObjectFactoryService = m_frontsidePolicy.ObjectFactoryService;

			// PersistenceService
			m_PersistenceService.ObjectRepresentationProvider = m_frontsidePolicy.ObjectRepresentationProvider;
			m_PersistenceService.Cache = m_CacheImpl.Cache;
			m_PersistenceService.PersistenceHandler = m_PersistenceHandlerImpl.PersistenceHandler;
			m_PersistenceService.ChangeHandler = m_ChangeHandler;

			// oclServices
			m_oclServicesImpl.ExtentService = DefaultExtentService;
			m_oclServicesImpl.ExternalIdService = DefaultExternalIdService;
			m_oclServicesImpl.PersistenceService = DefaultPersistenceService;
			m_oclServicesImpl.VersionService = m_VersionService;
			m_oclServicesImpl.UndoService = m_UndoImpl.UndoService;
			m_oclServicesImpl.VariableFactory = m_VariableFactoryService;
			m_oclServicesImpl.ObjectFactory = m_frontsidePolicy.ObjectFactoryService;
			m_oclServicesImpl.Cache = m_CacheImpl.Cache;
			m_oclServicesImpl.ObjectRepresentationProvider = m_frontsidePolicy.ObjectRepresentationProvider;

			m_ecoServiceProvider.RegisterEcoService(typeof(IObjectFactoryService), m_frontsidePolicy.ObjectFactoryService);
			m_ecoServiceProvider.RegisterEcoService(typeof(IInternalObjectContentFactory), m_frontsidePolicy.InternalObjectContentFactory);

			m_ecoServiceProvider.RegisterEcoService(typeof(IExternalIdService), DefaultExternalIdService);
			m_ecoServiceProvider.RegisterEcoService(typeof(IUndoService), m_UndoImpl.UndoService);
			m_ecoServiceProvider.RegisterEcoService(typeof(IStateService), DefaultStateService);
			m_ecoServiceProvider.RegisterEcoService(typeof(IPersistenceService), DefaultPersistenceService);
			m_ecoServiceProvider.RegisterEcoService(typeof(IVersionService), m_VersionService);
			m_ecoServiceProvider.RegisterEcoService(typeof(IDirtyListService), m_DirtyListService);
			m_ecoServiceProvider.RegisterEcoService(typeof(IExtentService), m_ExtentService);
			m_ecoServiceProvider.RegisterEcoService(typeof(IVariableFactoryService), m_VariableFactoryService);

			m_ecoServiceProvider.RegisterEcoService(typeof(ITypeSystemService), GetTypeSystemProvider());
			m_ecoServiceProvider.RegisterEcoService(typeof(IOclService), m_oclServicesImpl.OclService);
			m_ecoServiceProvider.RegisterEcoService(typeof(IOclTypeService), m_oclServicesImpl.OclService);
			m_ecoServiceProvider.RegisterEcoService(typeof(IActionLanguageService), m_oclServicesImpl.ActionLanguageService);
			m_ecoServiceProvider.RegisterEcoService(typeof(IOclPsService), m_oclServicesImpl.OclPsService);
		}

		public DefaultEcoSpace(): base()
		{
			IEcoTypeSystem TypeSystem = GetTypeSystemProvider().TypeSystem;
			m_CacheImpl = new CacheImpl(TypeSystem);
			m_UndoImpl = new UndoImpl(TypeSystem);
			m_PersistenceHandlerImpl = new PersistenceHandlerImpl(TypeSystem);
			m_ExtentService = new ExtentServiceImpl(TypeSystem);
			m_VariableFactoryService = new VariableFactoryServiceImpl(TypeSystem);
			m_PersistenceService = new PersistenceServiceImpl(TypeSystem);
			Initialize();
			MandatoryParts.Add(m_VariableFactoryService);
			MandatoryParts.Add(m_frontsidePolicy);
			MandatoryParts.Add(m_ExtentService);
			MandatoryParts.Add(m_StateService);
			MandatoryParts.Add(m_VersionService);
			MandatoryParts.Add(m_DirtyListService);
			MandatoryParts.Add(m_ExternalIdService);
			MandatoryParts.Add(m_CacheImpl);
			MandatoryParts.Add(m_UndoImpl);
			MandatoryParts.Add(m_PersistenceHandlerImpl);
			MandatoryParts.Add(m_PersistenceService);  // FIXME could be make optional part, check consequences
		}


		[Browsable(false)]
		[DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
		public override IEcoTypeSystem TypeSystem
		{
			get
			{
				ITypeSystemService tss = GetTypeSystemProvider();
				if (tss != null)
				{
					return tss.TypeSystem;
				}
				else
				{
					return null;
				}
			}
		}

		private PersistenceMapper persistenceMapper;
		[LocalizableCategory(typeof(HandlesStringRes), "sCategoryPersistence")]
		[LocalizableDescription(typeof(HandlesStringRes), "sPropertyPersistenceMapper")]
		[DefaultValue(null)]
		public PersistenceMapper PersistenceMapper
		{
			get { return persistenceMapper; }
			set { persistenceMapper = value; }
		}

		[LocalizableCategory(typeof(HandlesStringRes), "sCategoryPersistence")]
		[LocalizableDescription(typeof(HandlesStringRes), "sPropertyOptimisticLocking")]
		[DefaultValue(false)]
		public bool OptimisticLocking
		{
			get { return m_PersistenceHandlerImpl.OptimisticLocking; }
			set { m_PersistenceHandlerImpl.OptimisticLocking = value; }
		}
		[LocalizableCategory(typeof(HandlesStringRes), "sCategoryPersistence")]
		[LocalizableDescription(typeof(HandlesStringRes), "sPropertyUpdateWholeObjects")]
		[DefaultValue(false)]
		public bool UpdateWholeObjects
		{
			get { return m_PersistenceHandlerImpl.UpdateWholeObjects; }
			set { m_PersistenceHandlerImpl.UpdateWholeObjects = value; }
		}

		private Publisher m_ActiveChangedPublisher = new Publisher();

		public override void  SubscribeToActive(ISubscriber subscriber)
		{
			m_ActiveChangedPublisher.AddSubscription(subscriber);
		}

		[LocalizableDescription(typeof(HandlesStringRes), "sEnforceStringLength")]
		[DefaultValue(false)]
		public bool EnforceStringLength
		{
			get { return FrontsidePolicy.EnforceStringLength; }
			set { FrontsidePolicy.EnforceStringLength = value; }
		}

		public void RegisterEcoService(Type serviceType, object service)
		{
        	EcoServiceProvider.RegisterEcoService(serviceType, service);
		}
	}
}

namespace Borland.Eco.Persistence
{
	public interface IAutoHookable
	{
		bool CanHookup(Component component);
		void AutoHookup(Component component);
	}
	public interface IPersistencemapperProvider
	{
		IPersistenceMapper GetPersistenceMapper(ITypeSystemService typeSystemService);
		void ReturnPersistenceMapper(IPersistenceMapper persistenceMapper);
	}

	public abstract class PersistenceMapper: System.ComponentModel.Component, IPersistencemapperProvider
	{
		public abstract IPersistenceMapper GetPersistenceMapper(ITypeSystemService typeSystemService);
		public abstract void ReturnPersistenceMapper(IPersistenceMapper persistenceMapper);
	}
}
